---
generated_at: 2026-01-30 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-WasmBrowser（ASP.NET Core統合）.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/wwwroot/index.html`
- E-02: `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/wwwroot/main.js`
- E-03: `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/Program.cs`
- E-04: `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/WasmBrowserClient.csproj`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | h3要素に"WasmBrowser"と表示される | E-01 (16行目: `<h3 id="header">WasmBrowser</h3>`) | ○ |
| C-02 | main.jsがモジュールとして読み込まれる | E-01 (12行目) | ○ |
| C-03 | dotnet.withConfigで設定を適用する | E-02 (7-9行目) | ○ |
| C-04 | window.locationからoriginとhrefを取得する | E-02 (11行目) | ○ |
| C-05 | runMainAndExitでMain関数を実行する | E-02 (12行目) | ○ |
| C-06 | 引数にurl, hrefを渡す | E-02 (12行目: `[url, window.location.href]`) | ○ |
| C-07 | 例外発生時にexit(2)を呼び出す | E-02 (16行目) | ○ |
| C-08 | Main関数がasync Task型で定義されている | E-03 (10行目) | ○ |
| C-09 | 引数が2つ未満の場合に例外をスローする | E-03 (12-13行目) | ○ |
| C-10 | SignalRTestインスタンスを作成してRun()を呼び出す | E-03 (15-17行目) | ○ |
| C-11 | 非0の結果で例外をスローする | E-03 (18-19行目) | ○ |
| C-12 | WasmEnableThreadsがtrueに設定されている | E-04 (11行目) | ○ |
| C-13 | StaticWebAssetBasePathがwasmclientに設定されている | E-04 (12行目) | ○ |
| C-14 | 関連機能が画面機能マッピングに記載されている | E-06 (画面No 15の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] HTML構造がindex.htmlと一致している
- [x] JavaScriptの処理フローがmain.jsと一致している
- [x] C#のMain関数がProgram.csと一致している
- [x] プロジェクト設定がWasmBrowserClient.csprojと一致している
- [x] 関連機能が画面機能マッピング.csvと一致している
